<div class="wrap">
    <h2>Atoo-Cleaner / WooCommerce</h2>
    <div class="clearfix"></div>

    <?php
    global $wpdb;
    if (isset($_POST['save'])) {
        require_once ATOO_CLEANER_DIR . 'atoo-cleaner-functions.php';

        //Si demande de suppression des produits de WooCommerce
        if (isset($_POST['CLEAN_PRODUCTS']) and $_POST['CLEAN_PRODUCTS'] == 'on') {
            if (AtooCleaner::remove_product_from_woocommerce()) {
                ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success">
                            <span style="font-size: 2em" class="fa fa-check-circle"></span>
                            <span style="font-size: 1.4em"> <?php _e('The products in WooCommerce have been removed.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            } else {
                ?>

                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <span style="font-size: 2em" class="fa fa-exclamation-triangle"></span>
                            <span style="font-size: 1.4em"> <?php _e('Cannot removed products in WooCommerce.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            }
        }

        //Si demande de suppression des clients et des commandes de WooCommerce
        if (isset($_POST['CLEAN_CUSTOMER_ORDERS']) and $_POST['CLEAN_CUSTOMER_ORDERS'] == 'on') {
            if (AtooCleaner::remove_customers_and_orders_from_woocommerce()) {
                ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success">
                            <span style="font-size: 2em" class="fa fa-check-circle"></span>
                            <span style="font-size: 1.4em"> <?php _e('The customers and orders in WooCommerce have been removed.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            } else {
                ?>

                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <span style="font-size: 2em" class="fa fa-exclamation-triangle"></span>
                            <span style="font-size: 1.4em"> <?php _e('Cannot removed customers and orders in WooCommerce.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            }
        }


        //Si demande de suppression des produits des tables AtooSync
        if (isset($_POST['CLEAN_ATOOSYNC_TABLES_PRODUCTS']) and $_POST['CLEAN_ATOOSYNC_TABLES_PRODUCTS'] == "on") {
            if (AtooCleaner::remove_product_from_atoosync_tables()) {
                ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success">
                            <span style="font-size: 2em" class="fa fa-check-circle"></span>
                            <span style="font-size: 1.4em"> <?php _e('The products in the Atoo-Sync tables have been removed.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            } else {
                ?>

                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <span style="font-size: 2em" class="fa fa-exclamation-triangle"></span>
                            <span style="font-size: 1.4em"> <?php _e('Cannot removed products in the Atoo-Sync tables.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            }
        }

        //Si demande de suppression des clients et commandes des tables AtooSync
        if (isset($_POST['CLEAN_ATOOSYNC_CUSTOMERS_ORDERS']) and $_POST['CLEAN_ATOOSYNC_CUSTOMERS_ORDERS'] == 'on') {
            if (AtooCleaner::remove_customers_and_orders_from_atoosync_tables()) {
                ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success">
                            <span style="font-size: 2em" class="fa fa-check-circle"></span>
                            <span style="font-size: 1.4em"> <?php _e('The customers and orders in the Atoo-Sync tables have been removed.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            } else {
                ?>

                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            <span style="font-size: 2em" class="fa fa-exclamation-triangle"></span>
                            <span style="font-size: 1.4em"> <?php _e('Cannot removed customers and orders in the Atoo-Sync tables.', 'atoo-cleaner'); ?></span>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
        ?>


        <?php
    }
    ?>
    <div class="row">
        <div class="col-lg-9 col-md-12">
            <section id="atoo_from" style="padding-bottom: 15px">
                <form class="form-horizontal" method="post" action=""  onsubmit=" return confirmModal()">
                    <div class="tab-content"
                         style="border-left: 1px solid #ddd; border-right: 1px solid #ddd; border-bottom: 1px solid #ddd;border-radius: 0px 0px 5px 5px; padding :15px 0px">
                        <div role="tabpanel" class="tab-pane fade in active" id="atoosync_tables">
                            <div class="col-md-12">
                                <legend><?php _e('Atoo-Sync Tables', 'atoo-cleaner'); ?></legend>
                                <div class="form-group">
                                    <label class="col-sm-3 control-label"
                                           for="CLEAN_ATOOSYNC_TABLES_PRODUCTS"><?php _e('Clean Atoo-Sync Products', 'atoo-cleaner'); ?></label>
                                    <div class="col-sm-9">
                                        <input name="CLEAN_ATOOSYNC_TABLES_PRODUCTS" id="CLEAN_ATOOSYNC_TABLES_PRODUCTS"
                                               type="checkbox"
                                               data-toggle="toggle" data-width="75" data-size="small"
                                               data-on="<?php _e('Yes', 'atoo-cleaner'); ?>" data-onstyle="success"
                                               data-offstyle="danger"
                                               data-off="<?php _e('No', 'atoo-cleaner'); ?>"/>
                                        <span class="help-block"><?php _e('Clean all Products data from Atoo-Sync tables.', 'atoo-cleaner'); ?></span>
                                    </div>
                                    <label class="col-sm-3 control-label"
                                           for="CLEAN_ATOOSYNC_CUSTOMERS_ORDERS"><?php _e('Clean Atoo-Sync Customers/Orders', 'atoo-cleaner'); ?></label>
                                    <div class="col-sm-9">
                                        <input name="CLEAN_ATOOSYNC_CUSTOMERS_ORDERS"
                                               id="CLEAN_ATOOSYNC_CUSTOMERS_ORDERS" type="checkbox"
                                               data-toggle="toggle" data-width="75" data-size="small"
                                               data-on="<?php _e('Yes', 'atoo-cleaner'); ?>" data-onstyle="success"
                                               data-offstyle="danger"
                                               data-off="<?php _e('No', 'atoo-cleaner'); ?>"/>
                                        <span class="help-block"><?php _e('Clean all customers/orders datas from Atoo-Sync tables.', 'atoo-cleaner'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade in active" id="woocommerce_products">
                            <div class="col-md-12">
                                <legend><?php _e('WooCommerce Products', 'atoo-cleaner'); ?></legend>
                                <div class="form-group">
                                    <label class="col-sm-3 control-label"
                                           for="CLEAN_PRODUCTS"><?php _e('Clean WooCommerce Products', 'atoo-cleaner'); ?></label>
                                    <div class="col-sm-9">
                                        <input name="CLEAN_PRODUCTS" id="CLEAN_PRODUCTS" type="checkbox"
                                               data-toggle="toggle" data-width="75" data-size="small"
                                               data-on="<?php _e('Yes', 'atoo-cleaner'); ?>" data-onstyle="success"
                                               data-offstyle="danger"
                                               data-off="<?php _e('No', 'atoo-cleaner'); ?>"/>
                                        <span class="help-block"><?php _e('Clean all products from WooCommerce.', 'atoo-cleaner'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div role="tabpanel" class="tab-pane fade in active" id="woocommerce_customers_orders">
                            <div class="col-md-12">
                                <legend><?php _e('WooCommerce Customers / Orders', 'atoo-cleaner'); ?></legend>
                                <div class="form-group">
                                    <label class="col-sm-3 control-label"
                                           for="CLEAN_CUSTOMER_ORDERS"><?php _e('Clean WooCommerce Customers/Orders', 'atoo-cleaner'); ?></label>
                                    <div class="col-sm-9">
                                        <input name="CLEAN_CUSTOMER_ORDERS" id="CLEAN_CUSTOMER_ORDERS" type="checkbox"
                                               data-toggle="toggle" data-width="75" data-size="small"
                                               data-on="<?php _e('Yes', 'atoo-cleaner'); ?>" data-onstyle="success"
                                               data-offstyle="danger"
                                               data-off="<?php _e('No', 'atoo-cleaner'); ?>"/>
                                        <span class="help-block"><?php _e('Clean all customers and orders from WooCommerce.', 'atoo-cleaner'); ?></span>
                                    </div>
                                </div>
                                <hr/>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="col-md-offset-3">
                            <button class="btn btn-primary" type="submit" name="save" value="save"><span
                                        class="fa fa-save"></span> <?php _e('Confirm', 'atoo-cleaner'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </section>
        </div>
    </div>
</div>

<script type="text/javascript">

    function confirmModal(){

        return confirm('<?php _e("Are you sure that you want to delete datas?", 'atoo-cleaner') ?> ',);

    }

    function responseError(errors){
        let errorLines ="";
        errors.forEach(editLineError);

        function editLineError(item, index) {
            errorLines += item + "<br>";
        }
    }

</script>
