<?php
if (!defined('ABSPATH') || !is_main_site()) return;

/*
 * Plugin Name: Atoo-cleaner
 * Plugin URI: https://www.atoo-next.net/nos-solutions/
 * Description: Clean Woocommerce.
 * Version: 1.0.0
 * Author: Atoo Next.
 * Author URI: https://www.atoo-next.net
 * Contributors: Atoo Next
 * Text Domain: atoo-cleaner
 * Domain Path: /languages/
 * WC requires at least: 5.9
 * WC tested up to: 6.1
 * License: Commercial
 * License URI: https://www.atoo-next.net/mentions-legales/
*/

global $wpdb;

define('_TABLE_ATOOSYNC_KEY_',       $wpdb->prefix.'atoosync_gescom_key');
define('_ATSCTABLEKEY_',             'atoosync_gescom_key');
define('_ATSCTABLEGESCOMDOCUMENTS_', $wpdb->prefix.'atoosync_gescom_documents');
define('_ATSCTORDERDOCUMENTSDIR_',   WP_CONTENT_DIR.'/uploads/atoosync_documents/' );
define('_ATSCTABLEPENDINGPRODUCTS',  $wpdb->prefix.'atoosync_pending_products');
define('_ATSCTABLECUSTOMERACCOUNT',  $wpdb->prefix.'atoosync_customer_account');
define('WP_PLUGINS',  WP_CONTENT_DIR.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR);
define('ATOO_CLEANER_DIR',  WP_PLUGINS.DIRECTORY_SEPARATOR.'atoo-cleaner'.DIRECTORY_SEPARATOR);

include_once(ABSPATH . 'wp-admin/includes/plugin.php');



if (!defined("ATOO_CLEANER_CONFIGPREFIX")) {
    define("ATOO_CLEANER_CONFIGPREFIX", 'AT-CL_');
}

function ATCl_plugin_activated() {
    $optionsToSetDefaultValue = array(
        'CLEAN_PRODUCTS' => 0,
        'CLEAN_CUSTOMER_ORDERS' => 0,
        'CLEAN_ATOOSYNC_TABLES' => 0,
    );

    foreach ($optionsToSetDefaultValue as $option => $defaultValue) {
        if (get_option(ATOO_CLEANER_CONFIGPREFIX . $option) == '') {
            update_option(ATOO_CLEANER_CONFIGPREFIX . $option, $defaultValue);
        }
    }
}
register_activation_hook(__FILE__, 'ATCl_plugin_activated');

require_once ATOO_CLEANER_DIR."/atoo-cleaner-functions.php";

// la page d'administration du plugin
function ATCL_main_page_callback(){
    if(!current_user_can("manage_woocommerce")){
        _e('You do not have sufficient permissions to access this page.','atoo-cleaner');
        die();
    }
    include_once ATOO_CLEANER_DIR.'includes/atoo-cleaner-configuration.php';
}

// Ajoute le lien dans le menu d'administration
function ATCL_add_admin_menu() {
    global $atcl_tool_menu;
    if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
        $atcl_tool_menu = add_submenu_page('woocommerce', 'Atoo-Cleaner', 'Atoo-Cleaner', 'manage_woocommerce', 'atoo-cleaner', 'ATCL_main_page_callback');
    } else {
        $atcl_tool_menu = add_menu_page('Atoo-Cleaner', 'Atoo-Cleaner', 'manage_options', 'atoo-cleaner', 'ATCL_main_page_callback', 'dashicons-update');
    }
}
add_action('admin_menu', 'ATCL_add_admin_menu');


//function ATCL_update_profile_fields($user_id) {
//    if (!current_user_can('edit_user', $user_id )) {
//        return false;
//    }
//
//    if (isset($_POST['ERP_ACCOUNT'])) {
//        $old_erp_account = AtooSyncGesComDatabase::getAtooSyncKeyValueByName('user_id', $user_id, 'atoosync_key') ?? '';
//
//        if ($old_erp_account !== $_POST['ERP_ACCOUNT']) {
//            AtooSyncGesComDatabase::updateCustomerAccount($user_id, $old_erp_account, $_POST['ERP_ACCOUNT']);
//        }
//    }
//}

add_action('admin_enqueue_scripts', 'ATCL_load_styles_and_scripts');
// charge le CSS et le JS complémentaire
function ATCL_load_styles_and_scripts($hook) {
    global $atcl_tool_menu;
    if($hook != $atcl_tool_menu){
        return;
    }
    wp_enqueue_style( 'bootstrap_css', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css' );
    wp_enqueue_script( 'bootstrap_js', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js' );
    wp_enqueue_style( 'font_awesome_css', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css' );

    wp_enqueue_style( 'bootstrap-toggle_css', 'https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css' );
    wp_enqueue_script( 'bootstrap-toggle_js', 'https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js' );

    wp_enqueue_script('jquery-ui-datepicker');
    wp_register_style('jquery-ui', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/base/jquery-ui.css');
    wp_enqueue_style('jquery-ui');
}

// Initialisation des langues
function ATCL_load_textdomain() {
    load_plugin_textdomain('atoo-cleaner', false, plugin_basename(dirname(__FILE__)) . '/languages');
}
add_action('plugins_loaded', 'ATCL_load_textdomain');

// Ajoute le lien de configuration du plugin
function ATCL_add_settings_link($links) {
    $settings_link = '<a href="admin.php?page=atoo-cleaner">' . __( 'Settings' ) . '</a>';
    $support_link = '<a target="_blank" href="https://my.atoo-next.net">' . __( 'Support' ) . '</a>';
    array_unshift( $links, $settings_link, $support_link );
    return $links;
}
$plugin = plugin_basename( __FILE__ );
add_filter("plugin_action_links_$plugin", 'ATCL_add_settings_link');

