<?php


class AtooCleaner
{


    /**
     * Supprime les produits des tables Atoo-Sync.
     *
     * @return bool
     */
    public
    static function remove_product_from_atoosync_tables()
    {
        $result = false;
        global $wpdb;

        //Supprime les références des produits
        $query = array('class' => 'product_id');
        $result = $wpdb->delete(_TABLE_ATOOSYNC_KEY_, $query);


        //Supprime les variations des produits
        if ($result !== false and $result >= 0) {
            $query = array('class' => 'attribute_taxonomie_id');
            $result = $wpdb->delete(_TABLE_ATOOSYNC_KEY_, $query);
        }

        //Supprime les catégories
        if ($result !== false and $result >= 0) {
            $query = array('class' => 'category_term_id');
            $result = $wpdb->delete(_TABLE_ATOOSYNC_KEY_, $query);
        }

        //Supprime les images
        if ($result !== false and $result >= 0) {
            $query = array('class' => 'image_id');
            $result = $wpdb->delete(_TABLE_ATOOSYNC_KEY_, $query);
        }

        //Supprime les documents
        if ($result !== false and $result >= 0) {
            $query = $wpdb->prepare("TRUNCATE TABLE `"._ATSCTABLEGESCOMDOCUMENTS_."`");
            $result = $wpdb->query($query);
        }

        return ($result !== false and $result >= 0);
    }

    /**
     * Supprime les produits des tables Atoo-Sync.
     *
     * @return bool
     */
    public
    static function remove_customers_and_orders_from_atoosync_tables()
    {
        global $wpdb;
        $result = false;

        //Supprime les clients
        $query = $wpdb->prepare("TRUNCATE TABLE `"._ATSCTABLECUSTOMERACCOUNT."`");
        $result = $wpdb->query($query);

        //Supprime les produits en attente
        if ($result) {
            $query = $wpdb->prepare("TRUNCATE TABLE `"._ATSCTABLEPENDINGPRODUCTS."`");
            $result = $wpdb->query($query);
        }

        //Supprime les clients
        if ($result) {
            $query = "DELETE FROM " . _TABLE_ATOOSYNC_KEY_ . " WHERE `class` like 'user_id'";
            $result = $wpdb->query($wpdb->prepare($query));
        }

        //Supprime les commandes
        if ($result !== false and $result >= 0) {
            $query = "DELETE FROM " . _TABLE_ATOOSYNC_KEY_ . " WHERE class like 'order_id'";
            $result = $wpdb->query($wpdb->prepare($query));
        }

        return ($result !== false and $result >= 0);
    }

    /**
     * Supprime les produits des tables Atoo-Sync.
     *
     * @return bool
     */
    public
    static function remove_product_from_woocommerce()
    {
        $result = false;
        global $wpdb;


        #region Les images

        //Images Attachées au produit
        $resultImageAttaments = $wpdb->get_results("SELECT `meta_value` FROM $wpdb->postmeta WHERE `meta_key` like '_product_image'", ARRAY_A);
        $query = "DELETE FROM " . $wpdb->postmeta . " WHERE `meta_key` like '_product_image')";
        $wpdb->query($wpdb->prepare($query));

        $attachmentIds = array();
        foreach ($resultImageAttaments as $resultImageAttament) {
            $attachmentIds = array_merge(explode(",", $resultImageAttament["meta_value"]), $attachmentIds);
        }
        //Boucles sur les post des images afin de les supprimers du site (physique)
        $imageLocations = $wpdb->get_results("SELECT `meta_value` FROM $wpdb->postmeta WHERE `meta_key` like '_wp_attached_file' and `post_id` IN ('" . implode("','", $attachmentIds) . "')", ARRAY_A);
        $imageDeleteLocations = array();
        foreach ($imageLocations as $imageLocation) {
            $imageDeleteLocations[] = WP_CONTENT_DIR . DIRECTORY_SEPARATOR . "uploads" . DIRECTORY_SEPARATOR . $imageLocation["meta_value"];
        }
        //suppression des attachments des images
        $query = "DELETE FROM " . $wpdb->postmeta . " WHERE post_id IN (SELECT ID FROM " . $wpdb->posts . " WHERE `meta_key` like '_wp_attached_file' and post_id IN ('" . implode("','", $attachmentIds) . "'))";
        $wpdb->query($wpdb->prepare($query));

        $query = "DELETE FROM " . $wpdb->posts . " WHERE ID IN ('" . implode("','", $attachmentIds) . "')";
        $wpdb->query($wpdb->prepare($query));

        foreach ($imageDeleteLocations as $imageDeleteLocation) {
            self::removeFile($imageDeleteLocation);
        }
        #endregion

        #region Les documents
        //récupération des id des postmeta des documents afin de connaître la localisation des fichiers à supprimer
        $serializePostMetaDocuments = $wpdb->get_results("SELECT `meta_value` FROM $wpdb->postmeta WHERE `meta_key` like 'wcpoa_attachment_url'", ARRAY_A);
        $postmetaDocuments = array();
        foreach ($serializePostMetaDocuments as $postMetaDocumentSerialized) {
            if (!empty($postMetaDocumentSerialized["meta_value"])) {
                $postmetaDocumentsUnserialized = unserialize($postMetaDocumentSerialized["meta_value"]);
                foreach ($postmetaDocumentsUnserialized as $item) {
                    if (!empty($item)) {
                        $postmetaDocuments[] = $item;
                    }
                }
            }
        }
        //récupération de la localisation des documents à supprimer.
        if (!empty($postmetaDocuments)) {
            $metaLocationDocuments = $wpdb->get_results("SELECT `meta_value` FROM $wpdb->postmeta WHERE post_id IN ('" . implode("','", $postmetaDocuments) . "')", ARRAY_A);

            //supprime les documents
            foreach ($metaLocationDocuments as $metaLocationDocument) {
                self::removeFile(WP_CONTENT_DIR . DIRECTORY_SEPARATOR . "uploads" . DIRECTORY_SEPARATOR . $metaLocationDocument["meta_value"]);
            }
            $query = "DELETE FROM " . $wpdb->postmeta . " WHERE post_id IN ('" . implode("','", $postmetaDocuments) . "')";
            $wpdb->query($wpdb->prepare($query));
        }
        #endregion

        #region CSP
        if (self::tableExist("wusp_group_product_price_mapping")) {
            $query = "DELETE FROM " . $wpdb->prefix . "wusp_group_product_price_mapping";
            $wpdb->query($wpdb->prepare($query));
        }
        if (self::tableExist("wusp_role_pricing_mapping")) {
            $query = "DELETE FROM " . $wpdb->prefix . "wusp_role_pricing_mapping";
            $wpdb->query($wpdb->prepare($query));
        }
        if (self::tableExist("wusp_user_pricing_mapping")) {
            $query = "DELETE FROM " . $wpdb->prefix . "wusp_user_pricing_mapping";
            $wpdb->query($wpdb->prepare($query));
        }
        #endregion

        #region Infos du produit
        //Supprésion des produits
        $query = "DELETE relations.*, taxes.*, terms.*
                    FROM " . $wpdb->term_relationships . "term_relationships AS relations
                    INNER JOIN " . $wpdb->term_taxonomy . "term_taxonomy AS taxes
                    ON relations.term_taxonomy_id=taxes.term_taxonomy_id
                    INNER JOIN " . $wpdb->terms . " AS terms
                    ON taxes.term_id=terms.term_id
                    WHERE object_id IN (SELECT ID FROM " . $wpdb->posts . " WHERE post_type  IN ('product','product_variation'));";
        $wpdb->query($wpdb->prepare($query));



        $query = "DELETE FROM " . $wpdb->postmeta . " WHERE `post_id` IN (SELECT ID FROM " . $wpdb->posts . " WHERE `post_type` IN ('product','product_variation'))";
        $result = $wpdb->query($wpdb->prepare($query));

        if ($result !== false) {
            $query = "DELETE FROM " . $wpdb->posts . " WHERE `post_type` IN ('product','product_variation')";
            $result = $wpdb->query($wpdb->prepare($query));
            if ($result === 0) {
                $result = true;
            }
        }
        #endregion


        return (bool)$result;
    }

    /**
     * fonction de suppression de l'arborescence de fichier.
     * utilisée uniquement dans le cadre des documents de produits
     * @param string $dir
     */
    private static function removeFile($dir)
    {
        $path = str_replace(["/", '\\'], DIRECTORY_SEPARATOR, $dir);
        if (file_exists(WP_CONTENT_DIR . '/uploads/' . $path)) {
            rmdir(WP_CONTENT_DIR . '/uploads/' . $path);
        }
    }

    /**
     * Vérifie si la table existe
     * @param $tableName
     * @return bool
     */
    private static function tableExist($tableName)
    {
        global $wpdb;
        //Prix spécifique de CSP
        $table = $wpdb->prefix . $tableName;
        $query = $wpdb->prepare("SHOW TABLES LIKE '%s'", $wpdb->esc_like($table));
        if ($wpdb->get_var($query) == $table) {
            return true;
        }
        return false;
    }

    /**
     * Supprime les produits des tables Atoo-Sync.
     *
     * @return bool
     */
    public
    static function remove_customers_and_orders_from_woocommerce()
    {
        global $wpdb;
        $result = false;

        //suppression des commandes
        $postOrders = $wpdb->get_results("SELECT `ID` FROM $wpdb->posts WHERE `post_type` like 'shop_order'", ARRAY_A);
        $orders = array();
        foreach ($postOrders as $postOrder){
            $orders[] = $postOrder["ID"];
        }

        $query = "DELETE FROM " . $wpdb->postmeta . " WHERE meta_key IN ('".implode("','",$orders)."')";
        $result = $wpdb->query($wpdb->prepare($query));

        if($result >=0 and $result !==false){
            $result = true;
        }

        if($result) {
            $query = "DELETE FROM " . $wpdb->posts . " WHERE ID IN ('" . implode("','", $orders) . "')";
            $result = $wpdb->query($wpdb->prepare($query));

            if($result >=0 and $result !==false){
                $result = true;
            }
        }



        if($result) {
            //suppression des clients
            $all_user_ids = $wpdb->get_results("SELECT `user_id`,`meta_value` FROM $wpdb->usermeta WHERE `meta_key` like 'wp_capabilities'", ARRAY_A);
            $user_ids = array_filter($all_user_ids, function ($user_meta) {
                $capatibilities = unserialize($user_meta["meta_value"]);
                if (array_key_exists("administrator", $capatibilities) and $capatibilities["administrator"] == 1) {
                    return false;
                }
                return true;
            });
            $user_ids = array();
            foreach ($all_user_ids as $user_meta) {
                $capatibilities = unserialize($user_meta["meta_value"]);
                if (!array_key_exists("administrator", $capatibilities) or $capatibilities["administrator"] == 0) {
                    $user_ids[] = $user_meta["user_id"];
                }
            }

            $query = "DELETE FROM " . $wpdb->usermeta . " WHERE meta_key IN ('" . implode("','", $user_ids) . "')";
            $result = $wpdb->query($wpdb->prepare($query));

            if($result >=0 and $result !==false){
                $result = true;
            }

            if($result){
                $query = "DELETE FROM " . $wpdb->users . " WHERE ID IN ('" . implode("','", $user_ids) . "')";
                $result = $wpdb->query($wpdb->prepare($query));

                if ($result >= 0 and $result !== false) {
                    $result = true;
                }
            }
        }
        return $result;
    }


}
