<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package     cleaner_muc
 * @subpackage  local_cleanurls
 * @author      Daniel Thee Roperto <daniel.roperto@catalyst-au.net>
 * @copyright   2017 Catalyst IT Australia {@link http://www.catalyst-au.net}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace cleaner_muc\event;

use cleaner_muc\dml\muc_config_db;
use context_system;
use core\event\base;

defined('MOODLE_INTERNAL') || die();

/**
 * Class muc_config_event
 *
 * @package     cleaner_muc
 * @subpackage  local_cleanurls
 * @author      Daniel Thee Roperto <daniel.roperto@catalyst-au.net>
 * @copyright   2017 Catalyst IT Australia {@link http://www.catalyst-au.net}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class muc_config_event extends base {
    public static function get_data_level_key_name() {
        global $CFG;
        return ($CFG->branch <= 26) ? 'level' : 'edulevel';
    }

    public static function fire($id, $environment) {
        $event = static::create(
            [
                'objectid' => $id,
                'other'    => ['wwwroot' => $environment],
            ]
        );

        $event->trigger();
    }

    /**
     * Set all required data properties:
     *  1/ crud - letter [crud]
     *  2/ edulevel - using a constant self::LEVEL_*.
     *  3/ objecttable - name of database table if objectid specified
     *
     * Optionally it can set:
     * a/ fixed system context
     *
     * @return void
     */
    protected function init() {
        $this->data[self::get_data_level_key_name()] = self::LEVEL_OTHER;
        $this->data['objecttable'] = muc_config_db::TABLE_NAME;
        $this->context = context_system::instance();
    }
}
